Scriptname MarbleMagicMarblePhantasmScript extends activemagiceffect  

import Utility

int instanceFX

Spell Property  MarbleSpellChainDrive  Auto
Spell Property  MarbleVoiceSlowTime100  Auto
Spell Property  MarbleSpellChainHit Auto

Sound Property MarbleSoundChainLink  Auto

Message Property MarbleMessageMagicka  Auto  

GlobalVariable Property MarblePhantasmTrigger Auto
GlobalVariable Property MarbleRequireMagicka  Auto
GlobalVariable Property MarbleDelay  Auto

Event OnEffectStart(Actor Target, Actor Caster)

	if MarblePhantasmTrigger.getValue() == 0 && Caster.GetAVPercentage("Magicka") >= MarbleRequireMagicka.getValue()

		MarbleVoiceSlowTime100.Cast(Caster)  

		MarblePhantasmTrigger.setValue(1)

		Caster.damageAV("Magicka", 9999.0)
		MarbleSpellChainDrive.Cast(Caster)

		instanceFX = MarbleSoundChainLink.play(Caster)

		While(MarblePhantasmTrigger.getValue() == 1)

			wait(MarbleDelay.getValue())
			MarbleSpellChainHit.Cast(Caster)

		endWhile

	else

		MarbleMessageMagicka.Show(3.0)
		MarblePhantasmTrigger.setValue(0)

	endif

endEvent

Event OnEffectFinish(Actor Target, Actor Caster)

	Sound.StopInstance(instanceFX) 
	MarblePhantasmTrigger.setValue(0)
	Caster.DispelSpell(MarbleVoiceSlowTime100)

EndEvent
